<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>
   <HEAD>
      <META HTTP-EQUIV="Pragma" CONTENT="no cache">
      <META NAME="Organization" CONTENT="The Scripps Research Institute">
      <META NAME="Copyright" CONTENT="The Scripps Research Institute">
      <META NAME="Version" CONTENT="1">
      <META NAME="Author" CONTENT="Jesus M. Castagnetto, jesusmc@scripps.edu">
      <META NAME="Keywords" CONTENT="metal, protein, metalloprotein, protein
                                     design, structure, database, molecular
                                     biology, metalloenzyme, metalloantibody,
                                     database, query, java">
      <META NAME="Description" CONTENT="A structural database of metal-binding
                                        sites in metalloproteins, including an
                                        interactive search and visualization
                                        interface.">
      <TITLE>
         MDB (Query Results) - Metalloprotein Site Database and Browser
      </TITLE>
      <SCRIPT TYPE="text/javascript" LANGUAGE="JavaScript"
              SRC="/javascript/mainbar.js">
      </SCRIPT>
   </HEAD>
   <BODY BGCOLOR="#FFFFFF">
      <TABLE BORDER=0 CELLSPACING=0 WIDTH="100%">
         <TR> 
            <TD COLSPAN=2>
               <?php virtual ("/include/navhead.inc") ?>
            </TD>
         </TR>
         <TR VALIGN="top">
            <TD BGCOLOR="#06F6FA" ROWSPAN=2>
               <?php virtual ("/include/navside.inc") ?>
            </TD>
            <TD>
               <HR><?php virtual ("/include/logo.inc") ?>
               <!-- END of MDB Logo -->
               <HR><H2 ALIGN="CENTER">Results of querying the MDB</H2>

               <?php
                  /* 
                   * Written by: Jesus M. Castagnetto
                   * Based on: search.php from the interactive browser interface 
                   * 
                   * This script performs a seach on the metallodb by using
                   * information from the simplified search form in the
                   * "Advanced Query" page.
                   */
                  /* Initialization of variables */
                  /* 
                   * This script assumes that the database server is in the same
                   * machine as the web server that invokes it.
                   */
                  $db = "metallodb";
                  $querylog = "tmp/search_form2.log";
                  $debug = false;
    
                  /* included scripts are in the /php_inc/ dir */
                  require("sql.inc");
                  require ("tables.inc");
                  require ("parseinput.inc");
    
                  /* Main */
    
                  /* 
                   * Get a connection and select the database
                   */
    
                  $link = SQL_pconnect ();
                  if ( !$link ) {
                     echo("Error connecting to the server\n");
                     echo(SQL_error() . "\n");
                     exit;
                  }
                  if(!SQL_select_db($db,$link)) {
                     echo("Error selecting database " . $db);
                     echo(SQL_error() . "\n");
                     exit;
                  }
                  /* Perform the search */
    
                  /* The form variables are:
                   * metal, num_lig, author = comma separated lists
                   * res,r_val = ranges of the form "-NNN"
                   * expdata = string
                   */
    
                  /* metal(s) requested */
                  if ($metal) {
                     $q_metal = parseList("site.metal = ",strtolower($metal));
                  } else {
                     $q_metal = "";
                  }
    
                  /* number of ligands requested */
                  if ($num_lig) {
                     $q_num_lig = parseList("site.num_ligands = ", $num_lig,
                                            ",", "", "");
                  } else {
                     $q_num_lig = "";
                  }
    
                  /* authors requested */
                  if ($author) {
                     $q_author = parseList("protein.authors like ",
                     strtolower($author), ",", "'%", "%'");
                  } else {
                     $q_author = "";
                  }
    
                  /* resolution requested */
                  if ($res) {
                     $q_res = parseRange("protein.resolution","-".$res);
                  } else {
                     $q_res = "";
                  }
    
                  /* r_value requested */
                  if ($r_val) {
                     $q_r_val = parseRange("protein.r_value","-".$r_val);
                  } else {
                     $q_r_val = "";
                  }
    
                  if ($expdata) {
                     if ($expdata == "any") {
                        $q_expdata = "(protein.expdata LIKE '%' OR 
                                       protein.expdata = NULL) ";
                     } elseif ($expdata == "others") {
                        $q_expdata = "((protein.expdata NOT LIKE '%x-ray%'
                                        AND ";
                        $q_expdata .= "protein.expdata NOT LIKE '%nmr%' AND ";
                        $q_expdata .= "protein.expdata NOT LIKE '%theor%') OR ";
                        $q_expdata .= "protein.expdata = NULL)";
                     } else {
                        $q_expdata = mkLikeOpt("protein.expdata", $expdata);
                     }
                  } else {
                     $q_expdata = "";
                  }
                  /* construct and submit the search */
                  $query = "SELECT DISTINCT site.source_id, site.site_id,
                            site.metal, site.num_ligands, protein.description";
                  $query .= " FROM protein,site WHERE ";

                  /* check the existence of each part of the query
                   * before sending
                   */
                  $qtemp = ($q_metal!="") ? $q_metal : "";
                  $qtemp .= ($qtemp!="" && $q_num_lig!="") ? " AND " .
                             $q_num_lig : $q_num_lig;
                  $qtemp .= ($qtemp!="" && $q_expdata!="") ? " AND " .
                             $q_expdata : $q_expdata;
                  $qtemp .= ($qtemp!="" && $q_r_val!="") ? " AND " .
                             $q_r_val : $q_r_val;
                  $qtemp .= ($qtemp!="" && $q_res!="") ? " AND " .
                             $q_res : $q_res;
                  $qtemp .= ($qtemp!="" && $q_author!="") ? " AND " . 
                             $q_author : $q_author;
                  $query .= $qtemp ;
                  $query .= " AND protein.source_id=site.source_id ORDER BY
                             site.site_id "; 
                  $query = strtolower(stripslashes($query));
                  /* save to a file for debugging */
                  if ($debug) {
                     $datestamp = date("Y-m-d#H:m:s#", time());
                     $dbgfp = fopen ($querylog, "a");
                     $ip = getenv("REMOTE_ADDR");
                     $agent = getenv("HTTP_USER_AGENT");
                     fwrite($dbgfp, "$datestamp");
                     fwrite($dbgfp, "$ip#$agent#");
                     fwrite($dbgfp, "$query");
                  }
                  /* Get the results and process */
                  $php_errormsg="";
                  @$result = SQL_query($query,$link);
                  $msqlerrormsg = SQL_error();
                  if ($php_errormsg!="") {
                     echo ("<HTML><BODY BGCOLOR=\"white\"><B>");
                     echo("PHP Error: ");
                     echo($php_errormsg . "<P>");
                     if ($msqlerrormsg != "") {
                        echo("mSQL Error: " . $msqlerrormsg );
                     }
                     echo ("</B></BODY></HTML>");
                     fwrite ($dbgfp, "#ERROR IN QUERY: PHP=" . $php_errormsg . 
                             " mSQL=" . $msqlerrormsg . "\n");
                     fclose ($dbgfp);
                     exit;
                  }
                  @$nrows = SQL_num_rows($result);
                  /* Output the query variables */
                  $hitstr = ( $nrows > 1 ) ? " hits" : " hit";
                  $outvar = "<DIV ALIGN=\"CENTER\"><B>Your query was:</B><BR>";
                  $outvar .= "[Metal(s)=" . $metal . 
                             "] AND [Number of Ligands= " . $num_lig;
                  $outvar .= "] AND [Resolution&lt;=" . $res .
                             "] AND [R-value&lt;=" . $r_val;
                  $outvar .= "] AND [Expdata=" . $expdata .
                             "] AND [Author(s)=" . $author;
                  $outvar .= "] AND [you asked to show (at the most) " .
                             $showhits;
                  $outvar .= " hits per page. <B>This search found: " .
                             $nrows . $hitstr . "</B></DIV>\n";
                  echo ($outvar);
                  /* create hits table only if we got some results */
                  if ($nrows > 0) {
                     if ($showhits=="all") {
                        $max = $nrows;
                     } else {
                        $max = min((int)$showhits,(int)$nrows); 
                     }
                     $rightlower = $max + 1;
                     $rightupper = min(2*$max,$nrows);
	
                     $showing = "<P><DIV ALIGN=\"CENTER\"><B><U>
                                 Showing results: 1 ";
                     $showing .= " to " . (int) $max . "</U></B></DIV>";
                     echo ($showing);
    
                     if ($rightlower <= $nrows) {
                        echo ("<DIV ALIGN=\"CENTER\">\n
                               <TABLE WIDTH=\"90%\">\n<TR>\n");
                        echo ("<TD ALIGN=\"RIGHT\">\n");

                        makeForm(urlencode($outvar), urlencode($query), $nrows,
                                 $max, $rightlower, $rightupper);
                        echo ("</TD>\n");
                        echo ("</TR>\n</TABLE>\n</DIV>");
                     }
                     makeTable($result,$max);

                     if ($rightlower <= $nrows) {
                        echo ("<DIV ALIGN=\"CENTER\">\n
                               <TABLE WIDTH=\"90%\">\n<TR>\n");
                        echo ("<TD ALIGN=\"RIGHT\">\n");
                        makeForm(urlencode($outvar), urlencode($query), $nrows,
                                 $max, $rightlower, $rightupper);
                        echo ("</TD>\n");
                        echo("</TR>\n</TABLE>\n</DIV>");
                     }    
                  } else {
                     echo ("<DIV ALIGN=\"CENTER\" STYLE=\"background: yellow;\">
                            <BIG>No sites were found that matched your query
                            </BIG></DIV>");
                  }
                  if ($debug) {
                     fwrite($dbgfp,sprintf("#%d\n",$nrows));
                     fclose($dbgfp);
                  }
                  if ($result) SQL_free_result($result);
               ?>
    
            </TD>
         </TR>
         <TR>
            <TD ALIGN="CENTER" BGCOLOR="#E0FFFF">
               <HR WIDTH="50%">
               <?php virtual ("/include/nav_mdb_text.inc") ?>
               <HR WIDTH="50%">
            </TD>
         </TR>
         <TR>
            <TD COLSPAN=2 BGCOLOR="#06F6FA" ALIGN="CENTER">
               <?php virtual ("/include/navfoot.inc") ?>
            </TD>
         </TR>
      </TABLE><HR>
      <ADDRESS>
         <SMALL>
            Page maintained by Jesus M.
            Castagnetto (jesusmc@scripps.edu) -
            &copy; The Scripps Research Institute. <BR>
            Query performed on: <? echo (date("D, F d, Y - h:i a",time())) ?>
         </SMALL>
      </ADDRESS>
   </BODY>
</HTML>
